<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ImageProcess
 *
 * @author emady
 */
class ImageProcess  extends CI_Model {
    //put your code here
    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
    
    
    function imageUpload($oldimgName,$inputfield,$imgFolder,$imgWidth,$imgHeight,$thumbWidth,$thumbHeight,$imageinput,$table,$field,$arrayfield,$id,$primarykey,$hasThumb=TRUE){
               
        // =======  delete old images
        $oldimage = $this->input->post($oldimgName);                               
        if(@file_exists("images/$imgFolder/$oldimage")){
            @unlink("images/$imgFolder/$oldimage");                                                                    
            @unlink("images/$imgFolder/".$this->general->returnThumb($oldimage));                                                                    
        };    
                             
        // =======  upload new image
        $config = array(
            'upload_path' => "./uploads/",
            'allowed_types' => "gif|jpg|png|jpeg",
            'overwrite' => TRUE,
            'max_size' => "5048000", // Can be set to particular file size , here it is 2 MB(2048 Kb)            
            );
            $this->load->library('upload', $config);
            if($this->upload->do_upload($imageinput))
            {
                $data = array('upload_data' => $this->upload->data());                 
            }
            else
            {
                $error = array('error' => $this->upload->display_errors());    
                die($error);
            }    
        // save new image name in database
            $ext = $data['upload_data']['file_ext'];
            $imagesourcename = $data['upload_data']['file_name'];
            $newimgName   = $this->imageNaming($inputfield,$ext,$table,$field,$arrayfield,$id,$primarykey);                        
            
            
        // Configuration
        $config['image_library'] = 'gd2';
        // update the next line
        $config['source_image'] = './uploads/'.$imagesourcename;
        $config['new_image'] = './images/'.$imgFolder.'/'.$newimgName;                
        $config['maintain_ratio'] = TRUE;
        $config['width'] = $imgWidth;
        $config['height'] = $imgHeight;
        // Load the Library
        $this->load->library('image_lib', $config);
        // resize image
        $this->image_lib->resize();
        // handle if there is any problem
        if ( ! $this->image_lib->resize()){ 
         echo $this->image_lib->display_errors();
        }
        
        //create thumb 
        if($hasThumb)
        {            
            $this->image_lib->clear();
            $config['create_thumb'] = TRUE;
            $config['thumb_marker'] = "-th";
            $config['width'] = $thumbWidth;
            $config['height'] = $thumbHeight;            
            $this->image_lib->initialize($config);
            // resize image
            $this->image_lib->resize();
            // handle if there is any problem
            if ( ! $this->image_lib->resize()){ 
             echo $this->image_lib->display_errors();
            }
        }
        
        //clear image from uploads
        if(@file_exists("uploads/$imagesourcename")){
            @unlink("uploads/$imagesourcename");                                                                               
        };
            
        return $newimgName;
    }
       
    
    function imageNaming($imagename,$ext,$table,$field,$arrayfield,$id,$primarykey)
    {
        $imagefullname = $imagename.$ext;
        $result = $this->general->get_where_array($imagefullname,$arrayfield);                
        $imagerecord = $this->general->getAllRecordsWhereOr($table,$result,"$primarykey","asc");                    
                        
        if(count($imagerecord) > 0)
        {
            $i = 1;
            while(count($imagerecord) > 0)
            {                       
                $imagelastname = $imagename."-".$id.$i.$ext;  
                $result = $this->general->get_where_array($imagelastname,$arrayfield);                
                $imagerecord = $this->general->getAllRecordsWhereOr($table,$result,"$primarykey","asc");
                if(count($imagerecord) > 0)
                {
                    $i++;
                }
                else
                {
                    $updateData = array(
                        "$primarykey" => $id,
                        $field => $imagename."-".$id.$i.$ext
                    );
                    $this->general->updateRecord($table, $updateData, "$primarykey");
                    return $imagename."-".$id.$i.$ext;                    
                }
            }
        }
        else        
        {
         $updateData = array(
                        "$primarykey" => $id,
                        $field => $imagefullname
                    );
       $this->general->updateRecord($table, $updateData, "$primarykey");
        return $imagefullname;        
        }
    }
    
    function returnThumb($image)
    {
        if(strpos( $image, "." ) !== false)
        {
        $tmp = explode(".",$image);
        $iname = reset($tmp);
        $iext = end($tmp); 
        return $iname."-th.".$iext;
        }
        else
        {
            return "no-image.png";
        }
    }
}
